/**
 * Copyright (c) 2005, Freescale Semiconductor
 * Freescale Confidential Proprietary
 *
 * File name   : fir32.c
 * Project name: Mazatlan
 *
 * Author(s)   : Jaime Herrero
 *               Luis Reynoso
 * Department  : Guadalajara Applications Laboratory - RTAC Americas
 *
 * Description : iir32 Creation and Destruction 
 *               
 * History     :
 * 05/03/2005  : Created (A19257).
 */


#include "iir16.h"
#include "Memory\memalloc.h"

struct tIir16Struct* IIR16Create( Frac16* pCoef, uint16 u16Num){
    struct tIir16Struct* pIIR;
    
  	pIIR=(struct tIir16Struct*)memalloc(sizeof( struct tIir16Struct));
  	pIIR->pIirCoef=pCoef;
 	pIIR->iIirCoefCount=u16Num;
 	pIIR->pIirHistory=(Frac16*)memalloc((u16Num-1)*sizeof(Frac16));

    pIIR->iIirHistoryCount=0;

    return pIIR;    
}
	

void IIR16Destroy( struct tIir16Struct* pIIR){
    memfree (pIIR->pIirHistory);
    memfree (pIIR);
    return;
}
